procedure $workagg
argument local namelist freqs
argument local numeric series by case agelower
argument local numeric series by case ageupper
argument local string scalar rno
argument local string scalar targetdb = ""
argument local string scalar db_path = ""
block
   glue null
   overwrite on
   date * to *

   if (local'targetdb NE "")
      try
         open <ac over> file(trim(local'targetdb)) as todb
         store todb
         $search todb
      otherwise
         signal continue: "$workagg: Can't create DB "+local'targetdb+". Writing output "+NEWLINE+ &&
                          "          to WORK database"
         store work
         $search work
      end try
   else
      store work
      -- $search work
   end if

   if missing(location(@open.db,"CPSREV"))
      open <ac re> file(local'db_path+"cpscovar_rev.db") as cpsrev
      -local'cpsrevopened = TRUE
   else
      -local'cpsrevopened = FALSE
   end if

   if missing(location(@open.db,"LOUT"))
      open <ac re> file(local'db_path+"lfpr_run"+rno+".db") as lout
      -local'loutopened = TRUE
   else
      -local'loutopened = FALSE
   end if


   local'vrnames  = list("lfc", "ue",  "emp", "pop", "uen", "empn", "popn")
   local'doseas   = list(true,  true,  true,  false, false, false,  false)
   local'obtype   = list("ave", "ave", "ave", "ave", "sum", "sum",  "sum")

   loop for v=1 to lastvalue(local'vrnames)
      local'do_seas = if local'doseas[v] then 1 else 0   
      loop for s=1 to local'do_seas+1
         local'seas= if (s EQ 1) then "" else "_sa"; 
         loop for i=1 to lastvalue(local'agelower) -- group loop
            local'grpvar = "_a"+string(local'agelower[i])+"t"+string(local'ageupper[i])

            <case 1 to local'ageupper[i]-local'agelower[i]+1> -local'alist = nl(string(n+agelower[i]-1))
            
            if local'seas eq ""
               <ignore a,f> id(local'vrnames[v]+"m"+local'grpvar+local'seas) = lsum(crosslist({id(local'vrnames[v])},{"m_a"},alist))
               <ignore a,f> id(local'vrnames[v]+"f"+local'grpvar+local'seas) = lsum(crosslist({id(local'vrnames[v])},{"f_a"},alist))
            else
               <ignore a,f> id(local'vrnames[v]+"m"+local'grpvar+local'seas) = lsum(crosslist({id(local'vrnames[v])},{"m_a"},alist,{id(+local'seas)}))
               <ignore a,f> id(local'vrnames[v]+"f"+local'grpvar+local'seas) = lsum(crosslist({id(local'vrnames[v])},{"f_a"},alist,{id(+local'seas)}))
            end if
            <ignore a> id(local'vrnames[v]+local'grpvar+local'seas) = id(local'vrnames[v]+"m"+local'grpvar+local'seas)+id(local'vrnames[v]+"f"+local'grpvar+local'seas)

            execute "-"+local'vrnames[v]+"m"+local'grpvar+local'seas+"q = " + &&
               "convert("+local'vrnames[v]+"m"+local'grpvar+local'seas+",quarterly,discrete,"+local'obtype[v]+")"

            execute "-"+local'vrnames[v]+"f"+local'grpvar+local'seas+"q = " + &&
               "convert("+local'vrnames[v]+"f"+local'grpvar+local'seas+",quarterly,discrete,"+local'obtype[v]+")"

            execute "-"+local'vrnames[v]+local'grpvar+local'seas+"q = " + &&
               "convert("+local'vrnames[v]+local'grpvar+local'seas+",quarterly,discrete,"+local'obtype[v]+")"

            if (local'ageupper[i] eq 80)
               -local'grpvar2 = "_a"+string(local'agelower[i])+"p"
               alias(id(local'vrnames[v]+"m"+local'grpvar+local'seas)) = {id(local'vrnames[v]+"m"+local'grpvar2+local'seas)}
               alias(id(local'vrnames[v]+"f"+local'grpvar+local'seas)) = {id(local'vrnames[v]+"f"+local'grpvar2+local'seas)}
               alias(id(local'vrnames[v]+"m"+local'grpvar+local'seas+"q")) = {id(local'vrnames[v]+"m"+local'grpvar2+local'seas+"q")}
               alias(id(local'vrnames[v]+"f"+local'grpvar+local'seas+"q")) = {id(local'vrnames[v]+"f"+local'grpvar2+local'seas+"q")}
               alias(id(local'vrnames[v]+local'grpvar+local'seas)) = {id(local'vrnames[v]+local'grpvar2+local'seas)}
               alias(id(local'vrnames[v]+local'grpvar+local'seas+"q")) = {id(local'vrnames[v]+local'grpvar2+local'seas+"q")}
            end if           
         end loop -- i (group loop)
      end loop -- s (seasonal loop)
   end loop -- v

   loop for i=1 to lastvalue(local'agelower) -- group loop
      local'grpvar = "_a"+string(local'agelower[i])+"t"+string(local'ageupper[i])

      local'grpstrm = lout'lfpname+"m"+local'grpvar+local'seas+" = ("
      local'grpstrf = lout'lfpname+"f"+local'grpvar+local'seas+" = ("

      loop for a = local'agelower[i] to local'ageupper[i] -- age loop
         set local'grpstrm = local'grpstrm+"cpsrev'"+lout'lfpname+"m_a"+string(a)+"*cpsrev'popm_a"+string(a)+"+"
         set local'grpstrf = local'grpstrf+"cpsrev'"+lout'lfpname+"f_a"+string(a)+"*cpsrev'popf_a"+string(a)+"+"
      end loop

      set local'grpstrm = rtrim(local'grpstrm,"+")+")/popm"+local'grpvar
      set local'grpstrf = rtrim(local'grpstrf,"+")+")/popf"+local'grpvar

      execute local'grpstrm
      -id(lout'lfpname)&m&id(local'grpvar)&q = convert(id(lout'lfpname)&m&id(local'grpvar),quarterly,discrete,ave)

      execute local'grpstrf
      -id(lout'lfpname)&f&id(local'grpvar)&q = convert(id(lout'lfpname)&f&id(local'grpvar),quarterly,discrete,ave)

      -id(lout'lfpname+local'grpvar) = (id(lout'lfpname)&m&id(local'grpvar)*popm&id(local'grpvar)+id(lout'lfpname)&f&id(local'grpvar)*popf&id(local'grpvar))/pop&id(local'grpvar)
      -id(lout'lfpname+local'grpvar)&q = convert(id(lout'lfpname+local'grpvar),quarterly,discrete,ave)

      if (local'ageupper[i] eq 80)
         -local'grpvar2 = "_a"+string(local'agelower[i])+"p"
         alias(id(lout'lfpname+local'grpvar)) = {id(lout'lfpname+local'grpvar2)}
         alias(id(lout'lfpname+"m"+local'grpvar)) = {id(lout'lfpname+"m"+local'grpvar2)}
         alias(id(lout'lfpname+"f"+local'grpvar)) = {id(lout'lfpname+"f"+local'grpvar2)}
         alias(id(lout'lfpname+local'grpvar+"q")) = {id(lout'lfpname+local'grpvar2+"q")}
         alias(id(lout'lfpname+"m"+local'grpvar+"q")) = {id(lout'lfpname+"m"+local'grpvar2+"q")}
         alias(id(lout'lfpname+"f"+local'grpvar+"q")) = {id(lout'lfpname+"f"+local'grpvar2+"q")}
      end if
   end loop -- i (group loop)

   loop for i=1 to lastvalue(local'agelower)
      loop for k=1 to 2
         local'seas = if k EQ 1 then "" else "_sa"
         local'grpvar = "_a"+string(local'agelower[i])+"t"+string(local'ageupper[i])

         -ep&id(local'grpvar+local'seas) = &&
            if pop&id(local'grpvar) EQ 0 then 0 else emp&id(local'grpvar+local'seas)/pop&id(local'grpvar)
         -epm&id(local'grpvar+local'seas) = &&
            if popm&id(local'grpvar) EQ 0 then 0 else empm&id(local'grpvar+local'seas)/popm&id(local'grpvar)
         -epf&id(local'grpvar+local'seas) = &&
            if popf&id(local'grpvar) EQ 0 then 0 else empf&id(local'grpvar+local'seas)/popf&id(local'grpvar)
         -ep&id(local'grpvar+local'seas)&q = &&
            if pop&id(local'grpvar)&q EQ 0 then 0 else emp&id(local'grpvar+local'seas)&q/pop&id(local'grpvar)&q
         -epm&id(local'grpvar+local'seas)&q = &&
            if popm&id(local'grpvar)&q EQ 0 then 0 else empm&id(local'grpvar+local'seas)&q/popm&id(local'grpvar)&q
         -epf&id(local'grpvar+local'seas)&q = &&
            if popf&id(local'grpvar)&q EQ 0 then 0 else empf&id(local'grpvar+local'seas)&q/popf&id(local'grpvar)&q
         if (local'ageupper[i] eq 80)
            -local'grpvar2 = "_a"+string(local'agelower[i])+"p"
            alias(id("ep"+local'grpvar+local'seas)) = {id("ep"+local'grpvar2+local'seas)}
            alias(id("epm"+local'grpvar+local'seas)) = {id("epm"+local'grpvar2+local'seas)}
            alias(id("epf"+local'grpvar+local'seas)) = {id("epf"+local'grpvar2+local'seas)}
            alias(id("ep"+local'grpvar+local'seas+"q")) = {id("ep"+local'grpvar2+local'seas+"q")}
            alias(id("epm"+local'grpvar+local'seas+"q")) = {id("epm"+local'grpvar2+local'seas+"q")}
            alias(id("epf"+local'grpvar+local'seas+"q")) = {id("epf"+local'grpvar2+local'seas+"q")}
         end if

         -uep&id(local'grpvar+local'seas) = &&
            if pop&id(local'grpvar) EQ 0 then 0 else ue&id(local'grpvar+local'seas)/pop&id(local'grpvar)

         -uepm&id(local'grpvar+local'seas) = &&
            if popm&id(local'grpvar) EQ 0 then 0 else uem&id(local'grpvar+local'seas)/popm&id(local'grpvar)

         -uepf&id(local'grpvar+local'seas) = &&
            if popf&id(local'grpvar) EQ 0 then 0 else uef&id(local'grpvar+local'seas)/popf&id(local'grpvar)

         -uep&id(local'grpvar+local'seas)&q = &&
            if pop&id(local'grpvar)&q EQ 0 then 0 else ue&id(local'grpvar+local'seas)&q/pop&id(local'grpvar)&q

         -uepm&id(local'grpvar+local'seas)&q = &&
            if popm&id(local'grpvar)&q EQ 0 then 0 else uem&id(local'grpvar+local'seas)&q/popm&id(local'grpvar)&q

         -uepf&id(local'grpvar+local'seas)&q = &&
            if popf&id(local'grpvar)&q EQ 0 then 0 else uef&id(local'grpvar+local'seas)&q/popf&id(local'grpvar)&q

         if (local'ageupper[i] eq 80)
            -local'grpvar2 = "_a"+string(local'agelower[i])+"p"
            alias(id("uep"+local'grpvar+local'seas)) = {id("uep"+local'grpvar2+local'seas)}
            alias(id("uepm"+local'grpvar+local'seas)) = {id("uepm"+local'grpvar2+local'seas)}
            alias(id("uepf"+local'grpvar+local'seas)) = {id("uepf"+local'grpvar2+local'seas)}
            alias(id("uep"+local'grpvar+local'seas+"q")) = {id("uep"+local'grpvar2+local'seas+"q")}
            alias(id("uepm"+local'grpvar+local'seas+"q")) = {id("uepm"+local'grpvar2+local'seas+"q")}
            alias(id("uepf"+local'grpvar+local'seas+"q")) = {id("uepf"+local'grpvar2+local'seas+"q")}
         end if

         -uer&id(local'grpvar+local'seas) = &&
            if lfc&id(local'grpvar+local'seas) EQ 0 then 0 else ue&id(local'grpvar+local'seas)/lfc&id(local'grpvar+local'seas)
         -uerm&id(local'grpvar+local'seas) = &&
            if lfcm&id(local'grpvar+local'seas) EQ 0 then 0 else uem&id(local'grpvar+local'seas)/lfcm&id(local'grpvar+local'seas)
         -uerf&id(local'grpvar+local'seas) = &&
            if lfcf&id(local'grpvar+local'seas) EQ 0 then 0 else uef&id(local'grpvar+local'seas)/lfcf&id(local'grpvar+local'seas)
         -uer&id(local'grpvar+local'seas)&q = &&
            if lfc&id(local'grpvar+local'seas)&q EQ 0 then 0 else ue&id(local'grpvar+local'seas)&q/lfc&id(local'grpvar+local'seas)&q
         -uerm&id(local'grpvar+local'seas)&q = &&
            if lfcm&id(local'grpvar+local'seas)&q EQ 0 then 0 else uem&id(local'grpvar+local'seas)&q/lfcm&id(local'grpvar+local'seas)&q
         -uerf&id(local'grpvar+local'seas)&q = &&
            if lfcf&id(local'grpvar+local'seas)&q EQ 0 then 0 else uef&id(local'grpvar+local'seas)&q/lfcf&id(local'grpvar+local'seas)&q
         if (local'ageupper[i] eq 80)
            -local'grpvar2 = "_a"+string(local'agelower[i])+"p"
            alias(id("uer"+local'grpvar+local'seas)) = {id("uer"+local'grpvar2+local'seas)}
            alias(id("uerm"+local'grpvar+local'seas)) = {id("uerm"+local'grpvar2+local'seas)}
            alias(id("uerf"+local'grpvar+local'seas)) = {id("uerf"+local'grpvar2+local'seas)}
            alias(id("uer"+local'grpvar+local'seas+"q")) = {id("uer"+local'grpvar2+local'seas+"q")}
            alias(id("uerm"+local'grpvar+local'seas+"q")) = {id("uerm"+local'grpvar2+local'seas+"q")}
            alias(id("uerf"+local'grpvar+local'seas+"q")) = {id("uerf"+local'grpvar2+local'seas+"q")}
         end if

         -lfpr&id(local'grpvar+local'seas) = &&
            if pop&id(local'grpvar) EQ 0 then 0 else lfc&id(local'grpvar+local'seas)/pop&id(local'grpvar)
         -lfprm&id(local'grpvar+local'seas) = &&
            if popm&id(local'grpvar) EQ 0 then 0 else lfcm&id(local'grpvar+local'seas)/popm&id(local'grpvar)
         -lfprf&id(local'grpvar+local'seas) = &&
            if popf&id(local'grpvar) EQ 0 then 0 else lfcf&id(local'grpvar+local'seas)/popf&id(local'grpvar)
         -lfpr&id(local'grpvar+local'seas)&q = &&
            if pop&id(local'grpvar)&q EQ 0 then 0 else lfc&id(local'grpvar+local'seas)&q/pop&id(local'grpvar)&q
         -lfprm&id(local'grpvar+local'seas)&q = &&
            if popm&id(local'grpvar)&q EQ 0 then 0 else lfcm&id(local'grpvar+local'seas)&q/popm&id(local'grpvar)&q
         -lfprf&id(local'grpvar+local'seas)&q = &&
            if popf&id(local'grpvar)&q EQ 0 then 0 else lfcf&id(local'grpvar+local'seas)&q/popf&id(local'grpvar)&q
         if (local'ageupper[i] eq 80)
            -local'grpvar2 = "_a"+string(local'agelower[i])+"p"
            alias(id("lfpr"+local'grpvar+local'seas)) = {id("lfpr"+local'grpvar2+local'seas)}
            alias(id("lfprm"+local'grpvar+local'seas)) = {id("lfprm"+local'grpvar2+local'seas)}
            alias(id("lfprf"+local'grpvar+local'seas)) = {id("lfprf"+local'grpvar2+local'seas)}
            alias(id("lfpr"+local'grpvar+local'seas+"q")) = {id("lfpr"+local'grpvar2+local'seas+"q")}
            alias(id("lfprm"+local'grpvar+local'seas+"q")) = {id("lfprm"+local'grpvar2+local'seas+"q")}
            alias(id("lfprf"+local'grpvar+local'seas+"q")) = {id("lfprf"+local'grpvar2+local'seas+"q")}
         end if
      end loop -- k
   end loop -- i

   ---------------------------------------------------------------------
   -- THIS CODE CREATES SEX-SPECIFIC AGGREGATE TREND AND FITTED SERIES
   -- IN THE WORK DIRECTORY
   ---------------------------------------------------------------------
   loop for sfreq in freqs
      loop for grp = 1 to lastvalue(local'agelower)
         -local'thisgroup = "a"+string(local'agelower[grp])+"t"+string(ageupper[grp])
         -local'thisfreq = (if upper(name(sfreq)) eq "M" then "" else "q")
         if exists(modm_&id(thisgroup)&sfreq); next; end if   
         loop for sex in {m,f}
            -local'mtrendgrpstr = "mod"+name(sex)+"_"+thisgroup+name(sfreq)+" = ("
            -local'mpredgrpstr = "pred"+name(sex)+"_"+thisgroup+name(sfreq)+" = ("
            -local'mgrppopstr = "grppop"+name(sex)+"_"+thisgroup+name(sfreq)+" = "
            loop for age = agelower[grp] to ageupper[grp]
               if age EQ 80
                  set local'mtrendgrpstr = local'mtrendgrpstr+"(cpsrev'"+lout'lfpname+name(sex)+"_a80"+thisfreq+ &&
                                  "*cpsrev'ts"+name(sex)+"_a80"+thisfreq+")+"
                  set local'mpredgrpstr = local'mpredgrpstr+"(cpsrev'"+lout'lfpname+name(sex)+"_a80"+thisfreq+&&
                                  "*cpsrev'ts"+name(sex)+"_a80"+thisfreq+")+"
                  set local'mgrppopstr = local'mgrppopstr+"cpsrev'ts"+name(sex)+"_a"+string(age)+thisfreq+"+"
               else
                  set local'mtrendgrpstr = local'mtrendgrpstr+"(lout'"+lout'lfpname+"_mod"+name(sex)+string(age)+name(sfreq)+&&
                                  "*cpsrev'ts"+name(sex)+"_a"+string(age)+thisfreq+")+"
                  set local'mpredgrpstr = local'mpredgrpstr+"(lout'"+lout'lfpname+"_pred"+name(sex)+string(age)+name(sfreq)+ &&
                                  "*cpsrev'ts"+name(sex)+"_a"+string(age)+thisfreq+")+"
                  set local'mgrppopstr = local'mgrppopstr+"cpsrev'ts"+name(sex)+"_a"+string(age)+thisfreq+"+"
               end if
            end loop
            set local'mgrppopstr = rtrim(local'mgrppopstr,"+")
            execute local'mgrppopstr

            set local'mtrendgrpstr = rtrim(local'mtrendgrpstr,"+")+")/grppop"+name(sex)+"_"+thisgroup+name(sfreq)
            set local'mpredgrpstr = rtrim(local'mpredgrpstr,"+")+")/grppop"+name(sex)+"_"+thisgroup+name(sfreq)
            execute local'mtrendgrpstr
            execute local'mpredgrpstr
         end loop      

         id(lout'lfpname+"_mod_"+thisgroup)&_&sfreq = &&
            (modm_&id(thisgroup)&sfreq*grppopm_&id(thisgroup)&sfreq+ &&
             modf_&id(thisgroup)&sfreq*grppopf_&id(thisgroup)&sfreq)/ &&
            (grppopm_&id(thisgroup)&sfreq+grppopf_&id(thisgroup)&sfreq)
         id(lout'lfpname+"_pred_"+thisgroup)&_&sfreq = &&
            (predm_&id(thisgroup)&sfreq*grppopm_&id(thisgroup)&sfreq+ &&
             predf_&id(thisgroup)&sfreq*grppopf_&id(thisgroup)&sfreq)/ &&
            (grppopm_&id(thisgroup)&sfreq+grppopf_&id(thisgroup)&sfreq)

         if (local'ageupper[grp] eq 80)
            -local'grpvar2 = "a"+string(local'agelower[grp])+"p"
            alias(modm_&id(thisgroup)&sfreq) = {modm_&id(local'grpvar2)&sfreq}
            alias(modf_&id(thisgroup)&sfreq) = {modf_&id(local'grpvar2)&sfreq}
            alias(id(lout'lfpname+"_mod_"+thisgroup)&_&sfreq) = {id(lout'lfpname+"_mod_"+local'grpvar2)&_&sfreq}
            alias(predm_&id(thisgroup)&sfreq) = {predm_&id(local'grpvar2)&sfreq}
            alias(predf_&id(thisgroup)&sfreq) = {predf_&id(local'grpvar2)&sfreq}
            alias(id(lout'lfpname+"_pred_"+thisgroup+"_"+name(sfreq))) = {id(lout'lfpname+"_pred_"+local'grpvar2+"_"+name(sfreq))}
            alias(grppopm_&id(thisgroup)&sfreq) = {grppopm_&id(local'grpvar2)&sfreq}
            alias(grppopf_&id(thisgroup)&sfreq) = {grppopf_&id(local'grpvar2)&sfreq}
         end if

      end loop
   end loop

   if (local'cpsrevopened)
      close cpsrev
   end if

   if (local'loutopened)
      close lout
   end if

   if (not missing(location(@open.db,"TODB")))
      close todb
   end if

end block
end procedure
